# D11 — Light TOF (Time of Flight)

This bundle contains the **exact engine** and a **ready-to-run workspace** created at `2025-11-05T20-13-09Z`.

## How to re-run

From the bundle's root (same directory as `engine_d11_light_tof.py`):

```bash
python engine_d11_light_tof.py --manifest D11_light_tof/2025-11-05T20-13-09Z/config/manifest_d11_template.json --outdir D11_light_tof/2025-11-05T20-13-09Z/
```

Artifacts will be written under `D11_light_tof/2025-11-05T20-13-09Z/outputs/`.

- Metrics: `outputs/metrics/d11_tof_arrivals.csv`
- Audit: `outputs/audits/d11_tof_audit.json`
- Result line: `outputs/run_info/result_line.txt`

No external dependencies beyond Python stdlib.

## Notes
- Control is purely boolean/ordinal (integer shell equality).
- Readouts (regression, SR microcheck) are diagnostics-only.
- You can adjust `config/manifest_d11_template.json` (e.g., grid size) and re-run.
